/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFreeToInteractBlockMessage
extends AbstractColonyServerMessage {
    private BlockPos pos = new BlockPos(0, 0, 0);
    private BlockState block = Blocks.field_150346_d.func_176223_P();
    private MessageType type;
    private MessageMode mode;

    public ChangeFreeToInteractBlockMessage() {
    }

    public ChangeFreeToInteractBlockMessage(@NotNull IColonyView colony, @NotNull Block block, @NotNull MessageType type) {
        super(colony);
        this.pos = new BlockPos(0, 0, 0);
        this.block = block.func_176223_P();
        this.type = type;
        this.mode = MessageMode.BLOCK;
    }

    public ChangeFreeToInteractBlockMessage(@NotNull IColonyView colony, @NotNull BlockPos pos, @NotNull MessageType type) {
        super(colony);
        this.pos = pos;
        this.block = Blocks.field_150346_d.func_176223_P();
        this.type = type;
        this.mode = MessageMode.LOCATION;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.block = Block.func_196257_b((int)buf.readInt());
        this.pos = buf.func_179259_c();
        this.type = MessageType.values()[buf.readInt()];
        this.mode = MessageMode.values()[buf.readInt()];
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(Block.func_196246_j((BlockState)this.block));
        buf.func_179255_a(this.pos);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.mode.ordinal());
    }

    @Override
    @Nullable
    public Action permissionNeeded() {
        return Action.EDIT_PERMISSIONS;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        if (this.type == MessageType.ADD_BLOCK) {
            switch (this.mode) {
                case LOCATION: {
                    colony.addFreePosition(this.pos);
                    LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.item.permissionscepter.addposition.success", (Object[])new Object[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
                    break;
                }
                case BLOCK: {
                    colony.addFreeBlock(this.block.func_177230_c());
                    LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.item.permissionscepter.addblock.success", (Object[])new Object[]{this.block.func_177230_c().getRegistryName()});
                    break;
                }
            }
        } else {
            switch (this.mode) {
                case LOCATION: {
                    colony.removeFreePosition(this.pos);
                    LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.item.permissionscepter.removelocation.success", (Object[])new Object[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
                    break;
                }
                case BLOCK: {
                    colony.removeFreeBlock(this.block.func_177230_c());
                    LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.item.permissionscepter.removeblock.success", (Object[])new Object[]{this.block.func_177230_c().getRegistryName()});
                    break;
                }
            }
        }
    }

    public static enum MessageMode {
        LOCATION,
        BLOCK;

    }

    public static enum MessageType {
        REMOVE_BLOCK,
        ADD_BLOCK;

    }
}

